<?

function GetModRewriteStatus() {
  global $base_path;
  static $status = null;

  if (is_null($status)) {
    $lines = @file($base_path . ".htaccess");
    $arr = explode(':',$lines[3]);
    $status = trim($arr[1]);
  }
  return $status;
}

function GetModRewritePatternCategory() {
  global $base_path;
  static $pattern = null;

  if (is_null($pattern)) {
    $lines = @file($base_path . ".htaccess");
    $arr = explode(':',$lines[4]);
    $pattern = trim($arr[1]);
  }
  return $pattern;
}

function GetModRewritePatternDetail() {
  global $base_path;
  static $pattern = null;

  if (is_null($pattern)) {
    $lines = @file($base_path . ".htaccess");
    $arr = explode(':',$lines[5]);
    $pattern = trim($arr[1]);
  }
  return $pattern;
}

function WriteHtaccessToFile($status='', $category='', $detail='') {
  global $base_path;

  if(empty($status)) {
    $status = "0";
  }

  if(empty($category)) {
    $category = 'browse/{$cat_id}/{$page}/{$cat_name}.html';
  }

  if(empty($detail)) {
    $detail = 'detail/{$link_id}/{$link_title}.html';
  }

  $comment_tag = '';
  if ($status != 1) {
    $comment_tag = '# ';
  }

  $htaccess_string  = "# INDEXU-START\r\n\r\n";
  $htaccess_string .= "# DO NOT CHANGE THE FOLLOWING LINES\r\n";
  $htaccess_string .= "# status: " .$status. "\r\n";
  $htaccess_string .= "# pattern_category: " .$category. "\r\n";
  $htaccess_string .= "# pattern_detail: " .$detail. "\r\n\r\n";

  $htaccess_string .= "{$comment_tag}Options -MultiViews\r\n";
  $htaccess_string .= "{$comment_tag}RewriteEngine On\r\n\r\n";
  $htaccess_string .= GenerateHtaccessStringModrewriteDetail($detail, $comment_tag);
  $htaccess_string .= GenerateHtaccessStringModrewriteCategory($category, $comment_tag);
  $htaccess_string .= "\r\n# INDEXU-END";

  $htaccess_content = file_get_contents($base_path . ".htaccess");
  preg_match('|# INDEXU-START.*?# INDEXU-END|msi', $htaccess_content, $match);
  $htaccess_content = str_replace($match[0], $htaccess_string, $htaccess_content);

  $filename = $base_path . ".htaccess";
  $fp = fopen($filename, "w");
  fwrite($fp, $htaccess_content);
  fclose($fp);
}


function GenerateHtaccessStringModrewriteCategory($mod_rewrite_pattern, $comment_tag = '') {

  if (strpos($mod_rewrite_pattern, '{$cat_path}') === FALSE) {
    $array_var_pos = array();

    $pos = strpos($mod_rewrite_pattern, '{$cat_id}');
    if ($pos === false) { }
    else {
      $array_var_pos[$pos] = 'cat_id';
    }

    $pos = strpos($mod_rewrite_pattern, '{$page}');
    if ($pos === false) { }
    else {
      $array_var_pos[$pos] = 'page';
    }

    $pos = strpos($mod_rewrite_pattern, '{$cat_name}');
    if ($pos === false) { }
    else {
      $array_var_pos[$pos] = 'cat_name';
    }

    ksort($array_var_pos);
    $array_var_pos_values = array_values($array_var_pos);
    foreach($array_var_pos_values as $key => $val) {
      $ordered_pos[$val] = $key+1;
    }

    $mod_rewrite_pattern = str_replace('{$cat_id}','(.*)',$mod_rewrite_pattern);
    $mod_rewrite_pattern = str_replace('{$cat_name}','(.*)',$mod_rewrite_pattern);
    $mod_rewrite_pattern = str_replace('{$page}','(.*)',$mod_rewrite_pattern);
    $out .= "{$comment_tag}RewriteRule ^{$mod_rewrite_pattern} browse.php?cat=\${$ordered_pos[cat_id]}&pg_which=\${$ordered_pos[page]}\r\n";
  }
  else {
    $out .= "{$comment_tag}RewriteCond %{REQUEST_FILENAME} !-f\r\n";
    $out .= "{$comment_tag}RewriteCond %{REQUEST_FILENAME} !-d\r\n";
    $out .= "{$comment_tag}RewriteCond %{REQUEST_FILENAME} !-l\r\n";
    $out .= "{$comment_tag}RewriteRule ^.* browse.php\r\n";
  }

  return $out;
}

function GenerateHtaccessStringModrewriteDetail($mod_rewrite_pattern, $comment_tag = '') {

  $array_var_pos = array();

  $pos = strpos($mod_rewrite_pattern, '{$link_id}');
  if ($pos === false) { }
  else {
    $array_var_pos[$pos] = 'link_id';
  }

  $pos = strpos($mod_rewrite_pattern, '{$link_title}');
  if ($pos === false) { }
  else {
    $array_var_pos[$pos] = 'link_title';
  }

  ksort($array_var_pos);
  $array_var_pos_values = array_values($array_var_pos);
  foreach($array_var_pos_values as $key => $val) {
    $ordered_pos[$val] = $key+1;
  }

  $mod_rewrite_pattern = str_replace('{$link_id}','(.*)',$mod_rewrite_pattern);
  $mod_rewrite_pattern = str_replace('{$link_title}','(.*)',$mod_rewrite_pattern);

  $out .= "{$comment_tag}RewriteRule ^{$mod_rewrite_pattern} detail.php?linkid=\${$ordered_pos[link_id]}\r\n";

  return $out;
}

?>